/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于测试 /page/mod页面函数
*
* 修改:
*   1. 类型 : 创建
*      作者 : 李智明
*      时间 : 2021.05.25
*      内容 : 所有代码
************************************************************************************************/

/* exported tc_init_mod */
/* exported tc_record_mod */


/* global $ */
/* global mc_sdk_param */

// 页面层级
// 顶层
var obj_mod_iframe_top = "";
// main层
var obj_mod_iframe_sub_main = "";
// 子页面层
var obj_mod_iframe_child_page = "";
// 子页面dom层
var obj_mod_html_child_page = "";
// 子页面方面变量定义层
var obj_mod_window_child_page = "";

// 定义时间
var mod_time = 1000;

// 比较结果
var arr_mod_jungle_result = [];


// 数据 init
var obj_mod_init = {
    "hw": {
        "ctrl": "",
        "hub": ""
    },
    "appearance": {
        "dispchip": "",
        "scanchip": "",
        "w": "",
        "h": "",
        "group_cnt": "",
        "group_type": "",
        "serial_type": "",
        "electric_low": "",
        "second_time": ""
    },
    "level": {
        "tx": "",
        "oe": ""
    },
    "scan": {
        "scan_cnt": "",
        "scan_test": ""
    },
    "clr": {
        "st": "",
        "nd": "",
        "rd": "",
        "four": ""
    }
};

// page数据 / jungle数据
var obj_mod_page_data = {};
var obj_mod_jungle_data = {};


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试初始化界面数据是否正确
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/

function tc_init_mod(callback) {
    obj_mod_page_data = JSON.parse(JSON.stringify(obj_mod_init));
    obj_mod_jungle_data = mc_mod_get_data();
    localStorage.removeItem("MOD_WIZARD_DATA");
    mc_mod_clear_iframe_page();
    mc_mod_test_box_exist(function () {
        $(obj_mod_iframe_sub_main).contents().find("#mc_side_btn_add").click();
        setTimeout(() => {
            mc_mod_get_child_page(0, "iframe_content_subpage");
            // 获取界面数据
            obj_mod_page_data = mc_mod_get_page_data();

            // 比较数据
            arr_mod_jungle_result = mc_mod_jungle_data();

            if (!arr_mod_jungle_result[0]) {
                callback("0", arr_mod_jungle_result[1]);
            } else {
                callback("1", "测试完成,数据显示正确");
            }
            return;
        }, mod_time * 2);
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    测试界面记录功能
 * 参数:
 *    @param { Promise<Function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function tc_record_mod(callback) {
    obj_mod_page_data = JSON.parse(JSON.stringify(obj_mod_init));
    obj_mod_jungle_data = JSON.parse(JSON.stringify(obj_mod_init));
    localStorage.removeItem("MOD_WIZARD_DATA");
    mc_mod_clear_iframe_page();
    mc_mod_test_box_exist(function () {
        $(obj_mod_iframe_sub_main).contents().find("#mc_side_btn_add").click();
        setTimeout(() => {
            mc_mod_get_child_page(0, "iframe_content_subpage");
            // 操作界面
            mc_interface_operation();
            return;
        }, mod_time * 2);
    });
}


/* -------------------------------------------------------------------公共处理函数----------------------------------------------------------------- */
/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    模拟操作界面控件
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function mc_interface_operation() {
    obj_mod_html_child_page;
    // debugger;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    比较数据
 * 参数:
 *    NA
 * 返回:
 *    @return { Promise<obj> } obj 初始化数据
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function mc_mod_jungle_data() {
    var arr_result = [true, ""];

    for (var key in obj_mod_page_data) {
        if (obj_mod_page_data.hasOwnProperty(key)) {
            for (var id in obj_mod_page_data[key]) {
                if (obj_mod_page_data[key].hasOwnProperty(id)) {
                    if (!obj_mod_jungle_data[key][id]) {
                        continue;
                    }

                    if (obj_mod_jungle_data[key][id] !== obj_mod_page_data[key][id]) {
                        arr_result[0] = false;
                        arr_result[1] = "数据对比不一致,参数 : " + id;
                        return arr_result;
                    }
                }
            }
        }
    }

    return arr_result;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取界面数据
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function mc_mod_get_page_data() {
    var obj_data = JSON.parse(JSON.stringify(obj_mod_init));

    var arr_select_down_dom = obj_mod_html_child_page.getElementsByClassName("select_txt");
    var arr_step_dom = obj_mod_html_child_page.getElementsByClassName("mc_step_inp");
    var arr_check_dom = obj_mod_html_child_page.getElementsByClassName("mc_checkbox_on");
    var arr_select_btn_dom = obj_mod_html_child_page.getElementsByClassName("select_position");

    obj_data.hw.ctrl = arr_select_down_dom[0].innerText;
    obj_data.hw.hub = arr_select_down_dom[1].innerText;

    obj_data.appearance.dispchip = arr_select_down_dom[2].innerText;
    obj_data.appearance.scanchip = arr_select_down_dom[3].getAttribute("lang_id");
    obj_data.appearance.w = arr_step_dom[0].value;
    obj_data.appearance.h = arr_step_dom[1].value;
    obj_data.appearance.group_cnt = arr_step_dom[2].value;
    obj_data.appearance.group_type = arr_select_down_dom[4].getAttribute("lang_id");

    switch (obj_data.appearance.group_type) {
    case "MC_LANG_OPTION_STR_1_DSP":
        obj_data.appearance.group_type = "1";
        break;
    case "MC_LANG_OPTION_STR_3_DSP":
        obj_data.appearance.group_type = "3";
        break;
    case "MC_LANG_OPTION_STR_4_DSP":
        obj_data.appearance.group_type = "4";
        break;

    default:
        break;
    }

    obj_data.appearance.electric_low = arr_check_dom[0].innerText;

    if ("YES" === obj_data.appearance.electric_low) {
        obj_data.appearance.electric_low = true;
    } else {
        obj_data.appearance.electric_low = false;
    }

    obj_data.appearance.second_time = arr_select_down_dom[5].getAttribute("lang_id");

    switch (obj_data.appearance.second_time) {
    case "MC_LANG_OPTION_NOT_USE":
        obj_data.appearance.second_time = false;
        break;

    default:
        break;
    }

    if (arr_check_dom[1] && arr_check_dom[2]) {
        obj_data.level.tx = arr_check_dom[1].innerText;
        obj_data.level.oe = arr_check_dom[2].innerText;

        if ("YES" === obj_data.level.tx) {
            obj_data.level.tx = true;
        } else {
            obj_data.level.tx = false;
        }

        if ("YES" === obj_data.level.oe) {
            obj_data.level.oe = true;
        } else {
            obj_data.level.oe = false;
        }
    }


    obj_data.scan.scan_cnt = arr_step_dom[3].value;
    obj_data.scan.scan_test = arr_step_dom[4].value;

    obj_data.clr.st = arr_select_btn_dom[0].getAttribute("select_index");
    obj_data.clr.nd = arr_select_btn_dom[1].getAttribute("select_index");
    obj_data.clr.rd = arr_select_btn_dom[2].getAttribute("select_index");
    if (arr_select_btn_dom[3]) {
        obj_data.clr.four = arr_select_btn_dom[3].getAttribute("select_index");
    }


    return obj_data;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取初始化数据
 * 参数:
 *    NA
 * 返回:
 *    @return { Promise<obj> } obj 初始化数据
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function mc_mod_get_data() {
    var obj = JSON.parse(JSON.stringify(obj_mod_init));

    // 硬件
    obj.hw.ctrl = "FPGA";
    obj.hw.hub = "FPGA";
    // 电气
    obj.appearance.dispchip = "A5065";
    obj.appearance.scanchip = "138 DECODING";
    obj.appearance.w = "64";
    obj.appearance.h = "64";
    obj.appearance.group_cnt = "2";
    obj.appearance.group_type = "3";
    obj.appearance.electric_low = false;
    obj.appearance.second_time = false;
    // 极性
    obj.level.tx = "";
    obj.level.oe = "";

    // 行扫数
    obj.scan.scan_cnt = "32";
    obj.scan.scan_test = "1";

    // 颜色
    obj.clr.st = "1";
    obj.clr.nd = "2";
    obj.clr.rd = "3";
    return obj;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    清空所有子页面 和弹框
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function mc_mod_clear_iframe_page() {
    obj_mod_iframe_top = document.getElementById("tifrem_led");
    obj_mod_iframe_sub_main = obj_mod_iframe_top.contentDocument.getElementById("iframe_subpage");
    obj_mod_iframe_child_page = obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-iframe");

    var ui_iframe_page_cnt = obj_mod_iframe_child_page.length;

    // 提示弹框
    var arr_dialog_html = obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog");

    if (0 < arr_dialog_html.length) {
        obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].remove();
        obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
    for (var idx = 0; idx < ui_iframe_page_cnt; idx++) {
        obj_mod_iframe_child_page[0].remove();
        obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("layui-layer-shade")[0].remove();
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    检测当前界面是否创建箱体或模组
 *  * 参数:
 *    @param { Promise<function> } callback 比较数据
 * 返回:
 *    NA
 * 例子:
 *    先删箱体 再删模组
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function mc_mod_test_box_exist(callback) {
    mc_mod_open_side_page("mc_side_btn_box", function () {
        if (0 !== obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_box")[0].children.length) {
            var ui_box_cnt = obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_box")[0].children.length;

            for (var idx = 0; idx < ui_box_cnt; idx++) {
                var arr_each_box_dom = obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_box")[0].children[0];

                arr_each_box_dom.getElementsByClassName("icon-delete")[0].onclick();
            }
        }

        mc_mod_open_side_page("mc_side_btn_mod_wizard", function () {
            if (0 !== obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_mod")[0].children.length) {
                var ui_mod_cnt = obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_mod")[0].children.length;

                for (var id = 0; id < ui_mod_cnt; id++) {
                    var arr_each_mod_dom = obj_mod_iframe_sub_main.contentDocument.getElementsByClassName("mc_test_side_mod")[0].children[0];

                    arr_each_mod_dom.getElementsByClassName("icon-delete")[0].onclick();
                }
            }

            callback();
            return;
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    打开侧边栏界面
 * 参数:
 *    @param { Promise<string> } str_id 侧边栏按钮id
 *    @param { Promise<function> } callback 回调
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function mc_mod_open_side_page(str_id, callback) {
    $(obj_mod_iframe_sub_main).contents().find("#" + str_id).click();
    setTimeout(() => {
        callback();
        return;
    }, mod_time);
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    确认当前子页面
 * 参数:
 *    @param { Promise<string> } idx_page 需打开第几个iframe界面
 *    @param { Promise<string> } str_type 需打开第几个iframe界面
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    iframe_content_subpage 嵌在界面内
 *    layui-layer-iframe 弹出的界面 (主要是硬件选择界面)
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-05-25
 *       内容 : 所有代码
************************************************************************************************/
function mc_mod_get_child_page(idx_page, str_type) {
    if ("layui_layer_iframe" === str_type) {
        obj_mod_iframe_child_page = obj_mod_iframe_sub_main.contentDocument.getElementsByClassName(str_type);
        obj_mod_html_child_page = obj_mod_iframe_child_page[idx_page].getElementsByTagName("iframe")[0].contentDocument;
        obj_mod_window_child_page = obj_mod_iframe_child_page[idx_page].getElementsByTagName("iframe")[0].contentWindow;
    }
    if ("iframe_content_subpage" === str_type) {
        obj_mod_iframe_child_page = obj_mod_iframe_sub_main.contentDocument.getElementById(str_type);
        obj_mod_html_child_page = obj_mod_iframe_child_page.contentDocument;
        obj_mod_window_child_page = obj_mod_iframe_child_page.contentWindow;
    }

    if ("layui_layer_dialog" === str_type) {
        obj_mod_iframe_child_page = obj_mod_iframe_sub_main.contentDocument.getElementsByClassName(str_type);
        obj_mod_html_child_page = obj_mod_iframe_child_page[idx_page];
        obj_mod_window_child_page = obj_mod_iframe_child_page[idx_page];
    }

    return;
}

/* -------------------------------------------------------------------公共处理函数----------------------------------------------------------------- */

